<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Dashboard Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the dashboard pages to display
    | various messages and content to the user.
    |
    */

    // Common Management
    [
        'name' => 'Common Management',
        'slug' => 'common_management',
        'properties' => [
            'user_management' => 'User Management',
            'course_management' => 'Course Management',
            'content_management' => 'Content Management',
            'financial_management' => 'Financial Management',
            'refund_management' => 'Refund Management',
            'faq_management' => 'FAQ Management',
        ]
    ],

    // Common Settings
    [
        'name' => 'Common Settings',
        'slug' => 'common_settings',
        'properties' => [
            'security_settings' => 'Security Settings',
            'backup_settings' => 'Backup Settings',
            'tax_settings' => 'Tax Settings',
            'webhook_settings' => 'Webhook Settings',
        ]
    ],

    // Common Analytics & Reports
    [
        'name' => 'Common Analytics & Reports',
        'slug' => 'common_analytics_reports',
        'properties' => [
            'analytics' => 'Analytics',
            'reports' => 'Reports',
            'visitor_analytics' => 'Visitor Analytics',
            'course_analytics' => 'Course Analytics',
            'enrollment_statistics' => 'Enrollment Statistics',
            'revenue_statistics' => 'Revenue Statistics',
            'course_statistics' => 'Course Statistics',
            'sales_report' => 'Sales Report',
            'user_activity_report' => 'User Activity Report',
            'course_performance_report' => 'Course Performance Report',
            'financial_report' => 'Financial Report',
            'export_report' => 'Export Report',
        ]
    ],

    // Common Information & Details
    [
        'name' => 'Common Information & Details',
        'slug' => 'common_information_details',
        'properties' => [
            'basic_information' => 'Basic Information',
            'blog_information' => 'Blog Information',
            'user_information' => 'User Information',
            'media_details' => 'Media Details',
            'compensation_details' => 'Compensation & Details',
        ]
    ],

    // Common Totals
    [
        'name' => 'Common Totals',
        'slug' => 'common_totals',
        'properties' => [
            'total_blogs' => 'Total Blogs',
            'total_categories' => 'Total Categories',
            'total_jobs' => 'Total Jobs',
            'total_users' => 'Total Users',
            'total_earnings' => 'Total Earnings',
            'total_withdrawals' => 'Total Withdrawals',
        ]
    ],

    // Common Selectors
    [
        'name' => 'Common Selectors',
        'slug' => 'common_selectors',
        'properties' => [
            'select_user_type' => 'Select user type',
            'select_withdrawal_method' => 'Select withdrawal method',
            'select_recipients' => 'Select Recipients',
            'select_media' => 'Select Media',
        ]
    ],

    // Common Messages
    [
        'name' => 'Common Messages',
        'slug' => 'common_messages',
        'properties' => [
            'no_results' => 'No results.',
            'no_results_found' => 'No results found',
            'are_you_absolutely_sure' => 'Are you absolutely sure?',
            'update_the_category' => 'Update The Category',
            'image_upload_requirements' => 'Image upload is required',
        ]
    ],

    // Dashboard Related
    [
        'name' => 'Dashboard Related',
        'slug' => 'dashboard_related',
        'properties' => [
            'admin' => 'Admin',
            'archived' => 'Archived',
            'user_list' => 'User List',
            'instructor_list' => 'Instructor List',
            'course_list' => 'Course List',
            'newsletter_list' => 'Newsletter List',
            'payout_list' => 'Payout List',
            'lessons' => 'Lessons',
            'quizzes' => 'Quizzes',
            'total_content_items' => 'Total Content Items',
            'enrollment' => 'Enrollment',
            'course_status' => 'Course Status',
            'update_section' => 'Update Section',
            'update_lesson' => 'Update Lesson',
            'update_quiz' => 'Update Quiz',
            'sort_items' => 'Sort Items',
        ]
    ],

    // Job Circular Management
    [
        'name' => 'Job Circular Management',
        'slug' => 'job_circular_management',
        'properties' => [
            'job_circulars' => 'Job Circulars',
            'no_job_circulars_found' => 'No job circulars found',
            'provide_essential_job_details' => 'Provide the essential details about the job position',
            'specify_job_requirements' => 'Specify the requirements and qualifications for this position',
            'provide_salary_details' => 'Provide salary range and other compensation details',
            'salary_information' => 'Salary Information',
            'salary_information_title' => 'Set the compensation range for this position',
            'salary_range' => 'Salary Range',
            'salary_currency' => 'Salary Currency',
            'salary_negotiable' => 'Salary Negotiable',
            'application_deadline' => 'Application Deadline',
            'contact_email' => 'Contact Email',
            'skills_required' => 'Skills Required',
            'positions_available' => 'Positions Available',
            'job_type' => 'Job Type',
            'work_type' => 'Work Type',
            'experience_level' => 'Experience Level',
            'job_details' => 'Job Details',
            'job_details_title' => 'Specify the job type, location, and experience requirements',
        ]
    ],

    // Newsletter Management
    [
        'name' => 'Newsletter Management',
        'slug' => 'newsletter_management',
        'properties' => [
            'all' => 'All',
            'student' => 'Student',
            'send_to' => 'Send To',
            'send_newsletter' => 'Send newsletter',
            'no_newsletters_found' => 'No newsletters found',
        ]
    ],

    // Payout Management
    [
        'name' => 'Payout Management',
        'slug' => 'payout_management',
        'properties' => [
            'available' => 'Available',
            'total_payout' => 'Total Payout',
            'requested' => 'Requested',
            'withdraw_list' => 'Withdraw List',
            'payout_history' => 'Payout History',
            'payout_request' => 'Payout Request',
        ]
    ],

    // Instructor Management
    [
        'name' => 'Instructor Management',
        'slug' => 'instructor_management',
        'properties' => [
            'feedback' => 'Feedback',
            'course_instructor' => 'Course Instructor',
            'approval_status' => 'Approval Status',
        ]
    ],

    // Blog Management
    [
        'name' => 'Blog Management',
        'slug' => 'blog_management',
        'properties' => [
            'blog' => 'Blog',
            'add_new_blog' => 'Add new blog',
            'provide_essential_details' => 'Provide the essential details about your blog post',
            'blog_categories' => 'Blog Categories',
            'blog_category' => 'Blog Category',
            'protected_category' => 'Protected Category',
            'default_category_description' => 'When a specific category is deleted, all courses in that category will be moved to this default category. So default category cannot be edited or removed.',
            'protected_category_desc' => 'When a specific category is deleted, all courses in that category will be moved to this default category. So default category cannot be edited or removed.',
            'icon_picker' => 'Icon Picker',
            'sort_categories' => 'Sort Categories',
            'add_category' => 'Add Category',
            'create_category' => 'Create Category',
            'add_new_category' => 'Add New Category',
            'enter_blog_title' => 'Enter blog title',
            'blog_information' => 'Blog Information',
            'blog_information_desc' => 'Provide the essential details about your blog post',
            'enter_category_name' => 'Enter your category name',
            'pick_category_icon' => 'Pick your category icon',
            'category_status' => 'Category Status',
        ]
    ],

    // Newsletters
    [
        'name' => 'Newsletters',
        'slug' => 'newsletters',
        'properties' => [
            'all_users' => 'All Users',
            'only_students' => 'Only Students',
            'only_instructors' => 'Only Instructors',
        ]
    ],

    // Payouts
    [
        'name' => 'Payouts Details',
        'slug' => 'payouts_details',
        'properties' => [
            'pending_withdrawals' => 'Pending Withdrawals',
            'available_balance' => 'Available Balance',
            'withdraw_amount' => 'Withdraw Amount',
            'minimum_withdraw' => 'Minimum Withdraw',
            'maximum_withdraw' => 'Maximum Withdraw',
            'withdrawal_method' => 'Withdrawal Method',
            'withdrawal_note' => 'Withdrawal Note',
            'withdrawal_note_placeholder' => 'Add a note for this withdrawal (optional)',
        ]
    ],

    // Users
    [
        'name' => 'Users',
        'slug' => 'users',
        'properties' => [
            'user_role' => 'User Role',
            'provide_essential_user_details' => 'Provide the essential details about the user',
        ]
    ],

    // Content Management
    [
        'name' => 'Content Management',
        'slug' => 'content_management',
        'properties' => [
            'media_library' => 'Media Library',
            'file_manager' => 'File Manager',
            'upload_media' => 'Upload Media',
            'file_name' => 'File Name',
            'file_size' => 'File Size',
            'file_type' => 'File Type',
            'upload_date' => 'Upload Date',
            'dimensions' => 'Dimensions',

        ]
    ],

    // Communication Management
    [
        'name' => 'Communication Management',
        'slug' => 'communication_management',
        'properties' => [
            'notifications' => 'Notifications',
            'messages' => 'Messages',
            'announcements' => 'Announcements',
        ]
    ],

    // SEO Management
    [
        'name' => 'SEO Management',
        'slug' => 'seo_management',
        'properties' => [
            'meta_title' => 'Meta Title',
            'enter_meta_title' => 'Enter Meta Title',
            'meta_keywords' => 'Meta Keywords',
            'enter_meta_keywords' => 'Enter Meta Keywords',
            'meta_description' => 'Meta Description',
            'enter_meta_description' => 'Enter Meta Description',
            'og_title' => 'OG Title',
            'enter_og_title' => 'Enter OG Title',
            'og_description' => 'OG Description',
            'enter_og_description' => 'Enter OG Description',
        ]
    ],

    // Lesson Forms
    [
        'name' => 'Lesson Forms',
        'slug' => 'lesson_forms',
        'properties' => [
            'lesson_type' => 'Lesson Type',
            'video_file' => 'Video File',
            'video_url' => 'Video URL',
            'document_file' => 'Document File',
            'image_file' => 'Image File',
            'text_content' => 'Text Content',
            'embed_source' => 'Embed Source',
            'lesson_title' => 'Lesson Title',
            'lesson_status' => 'Lesson Status',
            'is_free' => 'Is Free',
            'lesson_description' => 'Lesson Description',
            'lesson_provider' => 'Lesson Provider',
            'lesson_source' => 'Lesson Source',
            'duration' => 'Duration',
            'lesson_summary' => 'Lesson Summary',
        ]
    ],

    // Quiz Forms
    [
        'name' => 'Quiz Forms',
        'slug' => 'quiz_forms',
        'properties' => [
            'quiz_title' => 'Quiz Title',
            'enter_quiz_title' => 'Enter quiz title',
            'total_mark' => 'Total Mark',
            'pass_mark' => 'Pass Mark',
            'retake' => 'Retake',
            'quiz_summary' => 'Quiz Summary',
            'hours' => 'Hours',
            'minutes' => 'Minutes',
            'seconds' => 'Seconds',
        ]
    ],

    // Question Forms
    [
        'name' => 'Question Forms',
        'slug' => 'question_forms',
        'properties' => [
            'question_type' => 'Question Type',
            'single_choice' => 'Single Choice',
            'multiple_choice' => 'Multiple Choice',
            'true_false' => 'True of False',
            'select_question_type' => 'Select question type',
            'question_title' => 'Question Title',
            'question_options' => 'Question Options',
            'correct_answer' => 'Correct Answer',
            'add_question' => 'Add Question',
            'edit_question' => 'Edit Question',
        ]
    ],

    // Course Content
    [
        'name' => 'Course Content',
        'slug' => 'course_content',
        'properties' => [
            'sections' => 'Sections',
            'section_title' => 'Section Title',
            'section_description' => 'Section Description',
            'lesson_content' => 'Lesson Content',
            'quiz_questions' => 'Quiz Questions',
            'assignments' => 'Assignments',
        ]
    ],

    // User Management
    [
        'name' => 'User Management',
        'slug' => 'user_management',
        'properties' => [
            'user_roles' => 'User Roles',
            'permissions' => 'Permissions',
            'user_activity' => 'User Activity',
            'login_history' => 'Login History',
            'user_preferences' => 'User Preferences',
            'update_user' => 'Update User',
            'select_approval_status' => 'Select the approval status',
        ]
    ],

    // Course Progress
    [
        'name' => 'Course Progress',
        'slug' => 'course_progress',
        'properties' => [
            'course_progress' => 'Course Progress',
            'completion_rate' => 'Completion Rate',
            'time_spent' => 'Time Spent',
            'quiz_scores' => 'Quiz Scores',
            'certificates_issued' => 'Certificates Issued',
        ]
    ],

    // Financial Management
    [
        'name' => 'Financial Management',
        'slug' => 'financial_management',
        'properties' => [
            'admin_revenue' => 'Admin Revenue',
            'instructor_revenue' => 'Instructor Revenue',
            'revenue_tracking' => 'Revenue Tracking',
            'commission_rates' => 'Commission Rates',
            'payment_history' => 'Payment History',
            'instructor_revenue_this_year' => 'Instructor Revenue This Year',
            'admin_revenue_this_year' => 'Admin Revenue This Year',
        ]
    ],

    // Content Moderation
    [
        'name' => 'Content Moderation',
        'slug' => 'content_moderation',
        'properties' => [
            'content_review' => 'Content Review',
            'flagged_content' => 'Flagged Content',
            'moderation_queue' => 'Moderation Queue',
            'content_guidelines' => 'Content Guidelines',
        ]
    ],

    // Support & Help
    [
        'name' => 'Support & Help',
        'slug' => 'support_help',
        'properties' => [
            'help_desk' => 'Help Desk',
            'support_tickets' => 'Support Tickets',
            'documentation' => 'Documentation',
        ]
    ],

    // Marketing
    [
        'name' => 'Marketing',
        'slug' => 'marketing',
        'properties' => [
            'marketing_campaigns' => 'Marketing Campaigns',
            'promotional_codes' => 'Promotional Codes',
            'affiliate_program' => 'Affiliate Program',
            'email_marketing' => 'Email Marketing',
        ]
    ],

    // Integration
    [
        'name' => 'Integration',
        'slug' => 'integration',
        'properties' => [
            'third_party_integrations' => 'Third Party Integrations',
            'api_management' => 'API Management',
            'external_services' => 'External Services',
        ]
    ],

    // Dashboard Statistics
    [
        'name' => 'Dashboard Statistics',
        'slug' => 'dashboard_statistics',
        'properties' => [
            'published' => 'Published',
            'draft' => 'Draft',
            'active' => 'Active',
            'inactive' => 'Inactive',
        ]
    ],

    // Course Forms
    [
        'name' => 'Course Forms',
        'slug' => 'course_forms',
        'properties' => [
            'category_required' => 'Category *',
            'select_course_instructor' => 'Select the course instructor',
            'status_required' => 'Status *',
        ]
    ],

    // Course Creation
    [
        'name' => 'Course Creation',
        'slug' => 'course_creation',
        'properties' => [
            'price' => 'Price',
            'enter_course_title' => 'Enter Course Title',
            'enter_short_description' => 'Enter Short Description',
            'type_content_here' => 'Type your content here...',
            'type_caption_optional' => 'Type caption for image (optional)',
            'course_status' => 'Course Status',
            'course_level' => 'Course Level',
            'course_language' => 'Course Language',
            'pricing_type_required' => 'Pricing type *',
            'enter_course_price' => 'Enter your course price ($0)',
            'check_course_discount' => 'Check if this course has discount',
            'enter_discount_price' => 'Enter discount price',
            'expiry_type' => 'Expiry Type',
            'expiry_duration' => 'Expiry Duration',
            'drip_content' => 'Drip Content',
            'enable_drip_content' => 'Enable drip content for this course',
            'course_instructor' => 'Course Instructor',
            'select_instructor' => 'Select the course instructor',
            'course_category' => 'Course Category',
            'select_category' => 'Select the course category',
        ]
    ],

    // Course Update Header
    [
        'name' => 'Course Update Header',
        'slug' => 'course_update_header',
        'properties' => [
            'course_preview' => 'Course Preview',
            'course_player' => 'Course Player',
            'submit_for_approval' => 'Submit for Approval',
            'course_approval_status' => 'Course Approval Status',
            'course_ready_approval' => 'This course is ready for approval!',
            'course_needs_attention' => 'This course needs attention before it can be approved:',
            'course_content_summary' => 'Course Content Summary',
        ]
    ],

    // Course Info
    [
        'name' => 'Course Info',
        'slug' => 'course_info',
        'properties' => [
            'course_faqs' => 'Course Faqs',
            'requirements' => 'Requirements',
            'outcomes' => 'Outcomes',
            'sort_items' => 'Sort Items',
        ]
    ],

    // Live Classes
    [
        'name' => 'Live Classes',
        'slug' => 'live_classes',
        'properties' => [
            'live_classes' => 'Live Classes',
            'schedule_new_live_class' => 'Schedule New Live Class',
            'schedule_live_class' => 'Schedule Live Class',
            'zoom_not_enabled' => 'Zoom is not enabled for this course. Please enable Zoom to schedule live classes.',
            'enable_zoom' => 'Enable Zoom',
            'no_live_classes_scheduled' => 'No Live Classes Scheduled',
            'schedule_first_live_class' => 'Schedule your first live class to get started with Zoom.',
            'class_topic_required' => 'Class Topic *',
            'enter_class_topic' => 'Enter class topic',
            'start_date_time_required' => 'Start Date & Time *',
            'class_notes_optional' => 'Class Notes (Optional)',
            'scheduling' => 'Scheduling...',
            'schedule_class' => 'Schedule Class',
            'join_class' => 'Join Class',
            'edit_class' => 'Edit Class',
            'delete_class' => 'Delete Class',
        ]
    ],

    // Media Management
    [
        'name' => 'Media Management',
        'slug' => 'media_management',
        'properties' => [
            'banner' => 'Banner',
            'thumbnail' => 'Thumbnail',
            'preview_video_type' => 'Preview Video Type',
            'preview_video_url' => 'Preview Video URL',
            'enter_video_url' => 'Enter video URL',
        ]
    ],

    // Question Forms
    [
        'name' => 'Question Forms',
        'slug' => 'question_forms',
        'properties' => [
            'single_choice' => 'Single Choice',
            'multiple_choice' => 'Multiple Choice',
            'true_false' => 'True of False',
            'select_question_type' => 'Select question type',
            'question_options' => 'Question Options',
            'correct_answer' => 'Correct Answer',
        ]
    ],

    // Blog Categories
    [
        'name' => 'Blog Categories',
        'slug' => 'blog_categories',
        'properties' => [
            'blog_categories' => 'Blog Categories',
            'blog_category' => 'Blog Category',
            'total_number_of_blog' => 'Total number of blog',
            'update_category' => 'Update Category',
            'category_description' => 'Category Description',
            'category_thumbnail' => 'Category Thumbnail',
        ]
    ],

    // Blog Form
    [
        'name' => 'Blog Form',
        'slug' => 'blog_form',
        'properties' => [
            'blog_information' => 'Blog Information',
            'provide_blog_details' => 'Provide the essential details about your blog post',
            'title_80_char' => 'Title (80 Character)',
            'enter_blog_title' => 'Enter blog title',
            'keywords_80_char' => 'Keywords (80 Character)',
            'enter_your_keywords' => 'Enter your keywords',
            'write_blog_content_here' => 'Write your blog content here...',
            'media_files' => 'Media Files',
            'upload_banner_thumbnail_desc' => 'Upload banner and thumbnail images for your blog',
            'blog_banner' => 'Blog Banner',
            'blog_thumbnail' => 'Blog Thumbnail',
            'update_blog' => 'Update Blog',
            'add_blog' => 'Add Blog'
        ]
    ],

    // Category Form
    [
        'name' => 'Category Form',
        'slug' => 'category_form',
        'properties' => [
            'enter_category_name' => 'Enter category name',
            'pick_category_icon' => 'Pick your category icon',
            'icon_picker' => 'Icon Picker',
            'subtitle_80_char' => 'Subtitle (80 Character)',
            'enter_category_description' => 'Enter category description',
        ]
    ],

    // Course Management
    [
        'name' => 'Course Management',
        'slug' => 'course_management',
        'properties' => [
            'course_faqs' => 'Course Faqs',
            'requirements' => 'Requirements',
            'outcomes' => 'Outcomes',
            'live_classes' => 'Live Classes',
            'no_live_classes_scheduled' => 'No Live Classes Scheduled',
            'schedule_first_live_class' => 'Schedule your first live class to get started with Zoom.',
            'zoom_not_enabled' => 'Zoom is not enabled for this course. Please enable Zoom to schedule live classes.',
            'enable_zoom' => 'Enable Zoom',
        ]
    ],

    // Course Forms
    [
        'name' => 'Course Forms',
        'slug' => 'course_forms',
        'properties' => [
            'course_title' => 'Course Title',
            'short_description' => 'Short Description',
            'course_instructor' => 'Course Instructor',
            'course_level' => 'Course Level',
            'made_in' => 'Made In',
            'enable_drip_content' => 'Enable Drip Content',
            'pricing_type' => 'Pricing type',
            'expiry_period_type' => 'Expiry period type',
            'expiry_date' => 'Expiry date',
            'preview_video' => 'Preview Video',
            'video_url' => 'Video URL',
            'video_file' => 'Video File',
        ]
    ],

    // SEO Form
    [
        'name' => 'SEO Form',
        'slug' => 'seo_form',
        'properties' => [
            'meta_title' => 'Meta Title',
            'meta_keywords' => 'Meta Keywords',
            'meta_description' => 'Meta Description',
            'og_title' => 'OG Title',
            'og_description' => 'OG Description',
        ]
    ],

    // Question Form
    [
        'name' => 'Question Form',
        'slug' => 'question_form',
        'properties' => [
            'question_type' => 'Question Type',
            'question_title' => 'Question Title',
            'single_choice' => 'Single Choice',
            'true_false' => 'True of False',
        ]
    ],

    // Lesson Form
    [
        'name' => 'Lesson Form',
        'slug' => 'lesson_form',
        'properties' => [
            'lesson_title' => 'Lesson Title',
            'lesson_status' => 'Lesson Status',
            'is_free' => 'Is Free',
            'lesson_type' => 'Lesson Type',
            'lesson_provider' => 'Lesson Provider',
            'lesson_duration' => 'Lesson Duration',
            'embed_source' => 'Embed Source',
            'video_file' => 'Video File',
            'video_url' => 'Video URL',
            'document_file' => 'Document File',
            'image_file' => 'Image File',
            'text_content' => 'Text Content',
        ]
    ],

    // Live Class Form
    [
        'name' => 'Live Class Form',
        'slug' => 'live_class_form',
        'properties' => [
            'class_topic' => 'Class Topic',
            'start_date_time' => 'Start Date & Time',
            'class_notes' => 'Class Notes (Optional)',
        ]
    ],

    // Course Status
    [
        'name' => 'Course Status',
        'slug' => 'course_status',
        'properties' => [
            'feedback' => 'Feedback',
            'course_approval_status' => 'Course Approval Status',
            'course_ready_approval' => 'This course is ready for approval!',
            'course_needs_attention' => 'This course needs attention before it can be approved:',
            'course_content_summary' => 'Course Content Summary',
        ]
    ],

    // Course Info Sections
    [
        'name' => 'Course Info Sections',
        'slug' => 'course_info_sections',
        'properties' => [
            'outcomes' => 'Outcomes',
            'course_faqs' => 'Course Faqs',
            'requirements' => 'Requirements',
            'section_title' => 'Section Title',
        ]
    ],

    // Live Class
    [
        'name' => 'Live Class',
        'slug' => 'live_class',
        'properties' => [
            'live_classes' => 'Live Classes',
            'no_live_classes_scheduled' => 'No Live Classes Scheduled',
            'zoom_not_enabled_message' => 'Zoom is not enabled for this course. Please enable Zoom to schedule live classes.',
            'schedule_first_live_class' => 'Schedule your first live class to get started with Zoom.',
        ]
    ],

    // Live Class Status
    [
        'name' => 'Live Class Status',
        'slug' => 'live_class_status',
        'properties' => [
            'live' => 'live',
            'upcoming' => 'upcoming',
            'ended' => 'ended',
            'scheduled' => 'scheduled',
        ]
    ],
];
